﻿var donotcalls = {
    context: $(".v-donotcalls"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-donotcallTable", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetDoNotCalls", "MultiMode", "Settings"),
            columns: [
                { "Title": resources.Phone, "Data": "Phone", "Name": "Phone", "HideInSelector": true  },
                { "Title": resources.RegistrationDate, "Data": "RegistrationDate", "Name": "RegistrationDate" },
                { "Title": resources.CreatedOn, "Data": "CreatedOn", "Name": "CreatedOn" }
            ],
            localizableTexts: { "Search": resources.SearchDNCList },
            stateKey: "DotNotCalls"
        });
    },
    bindEvents: function () {
        this.context.on("click", ".h-clearExpired", function () {
            modalDialog.showWindow(a4.getAction("DoNotCallClearExpired", "MultiMode", "Settings"), 300, 525);
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    },
    clearExpired: function (months) {
        var date = new Date();
        date.setMonth(date.getMonth() - months);
        date = a4.formatDate(date);
        modalDialog.showConfirmDialog(months > 0 ? confirmClearItemsResources : confirmClearItemsResourcesAll, function () {
            a4.callServerMethod(a4.getAction("DoNotCallsClearExpired", "MultiMode", "Settings"), { months: months },
                function (result) {
                    donotcalls.refreshContent();
                },
                function (error) {
                },
                { blockElement: donotcalls.context });
        }, 250, 550, true, { "date": date });
    }
};

$(document).ready(function () {
    if (donotcalls.context.length > 0) {
        donotcalls.initializeDataTable();
        donotcalls.bindEvents();
    }
});